/*
 * Decompiled with CFR 0.152.
 */
package com.work4games.main;

import com.work4games.entity.PlayerSave;
import com.work4games.gamestate.GameStateManager;
import com.work4games.handlers.Keys;
import com.work4games.main.Game;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import javax.swing.JPanel;

public class GamePanel
extends JPanel
implements Runnable,
KeyListener,
MouseListener,
MouseMotionListener {
    private Thread thread;
    private boolean running;
    private int FPS = 60;
    long wait = 0L;
    long targetTime = 1000 / this.FPS;
    long start;
    long elapsed;
    long totalElapsedTime;
    static long reportedFramerate = 0L;
    private BufferedImage image;
    private Graphics2D g;
    private GameStateManager gsm;
    int[] pixels = new int[256];
    Image imageC = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(16, 16, this.pixels, 0, 16));
    Cursor transparentCursor = Toolkit.getDefaultToolkit().createCustomCursor(this.imageC, new Point(0, 0), "invisibleCursor");
    boolean setCursor = false;

    public GamePanel() {
        this.setFocusable(true);
        this.requestFocus();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.addKeyListener(this);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.thread.start();
        }
    }

    private void init() {
        this.image = new BufferedImage(640, 480, 1);
        this.g = (Graphics2D)this.image.getGraphics();
        this.running = true;
        try {
            this.gsm = new GameStateManager();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        this.init();
        long lastTimeChecked = System.nanoTime();
        int frames = 0;
        while (this.running) {
            long start = System.nanoTime();
            this.update();
            this.draw();
            this.drawToScreen();
            long elapsed = System.nanoTime() - start;
            long wait = this.targetTime - elapsed / 1000000L;
            if (wait < 0L) {
                wait = 5L;
            }
            try {
                Thread.sleep(wait);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.totalElapsedTime = System.nanoTime();
            ++frames;
            if (System.nanoTime() - lastTimeChecked >= 1000000000L) {
                reportedFramerate = frames;
                frames = 0;
                lastTimeChecked = System.nanoTime();
            }
            PlayerSave.setTime(PlayerSave.getTime() + (this.totalElapsedTime - start) / 1000000L);
        }
    }

    private void update() {
        this.gsm.update();
        Keys.update();
        boolean bl = this.setCursor = !this.setCursor;
        if (PlayerSave.getPower() != 0L) {
            this.setCursor(this.transparentCursor);
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void draw() {
        this.gsm.draw(this.g);
    }

    private void drawToScreen() {
        if (!Game.loading) {
            Graphics g2 = this.getGraphics();
            g2.drawImage(this.image, 0, 0, 640, 480, null);
            g2.dispose();
        }
    }

    public static int getFPS() {
        return (int)reportedFramerate;
    }

    @Override
    public void keyPressed(KeyEvent key) {
        if (key.getKeyCode() == 77) {
            Game.loading = true;
            Game.setFullscreen(!Game.isFullscreen());
        }
        Keys.keySet(key.getKeyCode(), true);
    }

    @Override
    public void keyReleased(KeyEvent key) {
        Keys.keySet(key.getKeyCode(), false);
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        Keys.mouseX = -100.0;
        Keys.mouseY = -100.0;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Keys.mouseX = e.getX();
        Keys.mouseY = e.getY();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Keys.mouseX = e.getX();
        Keys.mouseY = e.getY();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Keys.mouseSet(e.getButton(), true);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Keys.isDown = false;
    }
}

